<?php

class EWRporta_Model_Templates extends XenForo_Model
{
	public function getTemplateBySlug($pageSlug)
	{
		if (!$template = $this->_getDb()->fetchRow("
			SELECT *
				FROM EWRporta_templates
			WHERE template_name = ?
		", $pageSlug))
		{
			return false;
		}

		return $template;
	}

	public function updateTemplate($input)
	{
		$dw = XenForo_DataWriter::create('EWRporta_DataWriter_Templates');

		if ($input['template_name'])
		{
			$dw->setExistingData($input);
		}

		$dw->set('template_name', $input['template_newname']);
		$dw->set('template_content', $input['template_content']);
		$dw->preSave();
		$dw->save();

		return true;
	}

	public function deleteTemplate($input)
	{
		$dw = XenForo_DataWriter::create('EWRporta_DataWriter_Templates');
		$dw->setExistingData($input);
		$dw->delete();

		return true;
	}
}